--------------------------------------------------------------------
--            SymCACP Script Module 1       
-- Symmetrical CA Control Panel   symCACPscript-1
--file for Strobe Ratio
-- After STEP1 gens collect STRIPLEN samples at CELL_X,CELL_Y
--------------------------------------------------------------------
--  P. Rendell   11/10/2022
--------------------------------------------------------------------
-- O/P
-- RULE,GEO, WD, SEED, START_X, START_Y, GEN, RUNLENG

--==============================================================================
------------------------------------------------------------

local scriptType = "script-strip2"
local m={}			-- class table
local comProcs			-- common Procedures
local logFile
local g = golly()
local scriptFileData
local logDiverted = false
local gr = require("buildUni") 
--  "r" = rule, "s" = seed, "d" = decimal "t" = text, "g" = geo
-- "R" = required
m.colonList = {['WIDTH'] = {"d","R"},['RULES'] = {"r","R"}, ['SEEDS'] = {"s","R"}}
m.equalList = {['LOGFILE'] = {'t',""}, ['RESULTS_OLD'] = {'t',""}, ['RESULTS_NEW'] = {'t',"R"},
                   ['STEP1'] = {"d","R"}, ['STRIPLENG'] = {"d","R"},  ['CELL_X'] = {'d',"R"}, ['CELL_Y'] = {'d',"R"},
                   ['GEO'] = {'g',""}, ['COMPLEMENT'] = {"d",""} }
------------------------------------------------------------------------------------------------


--==============================================================================
------------------------------------------------------------------------------------------------

function m.init(lf, cp)
   scriptFileData = {}
   comProcs = cp
   logFile = lf
end

------------------------------------------------------------------------------------------------
function m.buildParmVal(cmd, value, segNo)
   if (scriptFileData[cmd]) then
      m.report.collect("Previous value overwriten "..cmd.." = "..value.."\n",true, segNo)
   end
   scriptFileData[cmd] = value
end

------------------------------------------------------------------------------------------------
function m.buildParmLst(cmd, parms, segNo)
   if (not scriptFileData[cmd]) then
      scriptFileData[cmd] = {}
   end
   for i, parm in pairs(parms) do
      table.insert(scriptFileData[cmd],parm)
   end
end

------------------------------------------------------------------------------------------------
function m.validateScript()
   if not scriptFileData.HIGHT then
      scriptFileData.HIGHT = scriptFileData.WIDTH
   end
   if not scriptFileData.GEO then
      scriptFileData.GEO = "D"
   end
   return true
end
--==============================================================================
--==============================================================================

local function getSamples(h, leng)
   strip = {}
   local x = h.x
   local y = h.y
   
   for  pos = 1, leng do
      strip[pos] = g.getcell(x,y)
      g.run(1)
   end   
   return(strip)
end
--==============================================================================
--==============================================================================

local function writeHeader(outFile)
   outFile:write("RULE,GEO,WIDTH,SEED,START_X,START_Y,GEN,RUNLENG\n")
end
--==============================================================================
--==============================================================================

local function getRunlengs(h, leng)
   -- leng is number of gens to run for
   local x = h.x
   local y = h.y
   g.show("h.width "..(h.width-1)//2)
   local startLen = 1
   local started = false
   local doneLen = 0
   
   local gen = g.getgen()-1
   local strip = getSamples(h,leng)
   local pos0 = 1
   local outData = {}
--   logFile:write("new runlen "..h.rule..','..h.seed..','..h.x..','..h.y..'\n')
   for  pos1 = 2, leng do
      if (strip[pos0] ~= strip[pos1]) then
         if(started) then
            outData[#outData+1] = string.format("%s,%s,%s,%s,%s,%s,%i,%i\n", h.rule, h.geo, h.width, h.seed, h.x, h.y, gen+pos0-1, pos1-pos0-1)
         end
         started = true
         pos0 = pos1
      end
   end
   return(outData)
end
------------------------------------------------------------
------------------------------------------------------------
-- If a run is interruppted then the last seed run can be ignored as it will be incomplete.
-- 
local function openOutFile()
   local s = {}
   local lastSeedRun = {}
   local lastSeedRunKey = ''
   local inFile, outFile, line, words, key, noLines
   local outFileOpen = false
   local inFileOpen = false
   s.linesDone = {}
   if scriptFileData then
      inFile = io.open ( scriptFileData.RESULTS_NEW , "r")
      if inFile and scriptFileData.RESULTS_OLD then   
         inFileOpen = true
         outFile = io.open ( scriptFileData.RESULTS_OLD , "w")
         if outFile then
            line = inFile:read("*l")
            while line do
               outFile:write(line..'\n')
               line = inFile:read("*l")
            end
            inFile:close()
            inFileOpen = false
            outFile:close()
            s.outFile = io.open ( scriptFileData.RESULTS_NEW , "w")
            writeHeader(s.outFile)
            outFileOpen = true
         else
            comProcs.showTextOV('Failed to input output file '..scriptFileData.RESULTS_NEW)
            logFile:write('Failed to open input file '.."scriptFileData.RESULTS_NEW\n")
         end
      end
      if inFileOpen then
         inFile:close()
      end
      if not outFileOpen then
         s.outFile = io.open ( scriptFileData.RESULTS_NEW , "w")
         writeHeader(s.outFile)
      end
      if not s.outFile then
         comProcs.showTextOV('Failed to open output file '..scriptFileData.RESULTS_NEW)
         logFile:write('Failed to open input file '.."scriptFileData.RESULTS_NEW\n")
      end
   else
      comProcs.showTextOV('No Script file Loaded')
   end
   return(s)
end
------------------------------------------------------------

local function divertLog()
   res = true
   local log = io.open ( scriptFileData.LOGFILE , "w")
   if log then
      logFile:write('Diverting to logfile '..scriptFileData.LOGFILE..'\n')
      logDiverted = true
      logFile:close()
      logFile = log
      log = nil
      comProcs.newLog(logFile)
   else
      logFile:write('Failed to divert to logfile '..scriptFileData.LOGFILE..'\n')
      res = false
   end
   return res
end
------------------------------------------------------------

local function reDivertLog()
   if logDiverted then
      logFile:close()
      logFile = comProcs.oldLog()
      logFile:write('Continue after log diversion\n')
   end
   logDiverted = false
end
------------------------------------------------------------

function m.run(segmentNo)

   ---------------------  script data-----------------------
   --  WIDTH =,HIGHT =,RANDSEED =, STRIPLENG =, DO=STRIP
   --  SEEDS:, STEP1 =,RULES:
   ---------------------------------------------------------
   local seed, tx,ty, gen, outFile, inFile
   local line, headerLine, noLines
   local outData = {}
   local stop = false
   local h = {}
   local startTime = os.clock()
   g.show("Script Strip Analysis")

   g.show('Strip Analysis Started')
   logFile:write('\nStrip Analysis Started\n')
   if scriptFileData then
      if scriptFileData.LOGFILE then
         logDiverted = divertLog(scriptFileData.LOGFILE)
      end
      comProcs.LogScript(segmentNo)
      local geoList = {'D','O'}
      if scriptFileData.GEO ~= 'B' then
         geoList = {scriptFileData.GEO}
      end
      s = openOutFile()
      if s.outFile then
         for ir = 1, #scriptFileData.RULES,1 do
            h.rule = scriptFileData.RULES[ir]
            if(scriptFileData.COMPLEMENT > 0) then
               h.rule = gr.comp(scriptFileData.RULES[ir])
            end
            g.new('SymCACP Script '..scriptFileData.RESULTS_NEW..' '..h.rule..' ')
            for is = 1, #scriptFileData.SEEDS,1 do
               h.seed = scriptFileData.SEEDS[is]
               for widthI,widthV in pairs(scriptFileData.WIDTH) do    
                  h.width = widthV
                  h.hight = h.width
                  for geoI,geoV in pairs(geoList) do
                     h.geo = geoV:sub(1,2)
                     h.x = scriptFileData.CELL_X
                     h.y = scriptFileData.CELL_Y
                     h.gen = scriptFileData.STEP1
                     step = scriptFileData.STEP1
                     gr.doBuild(' SymCACP Strip ', h.width, h.hight, h.seed, h.geo, h.rule)  -- w, h, seed, rule, format
                     g.run(step)
                     g.update()
                     outData = getRunlengs(h, scriptFileData.STRIPLENG)
                     for i,line in pairs(outData) do
			   s.outFile:write(line) 
                     end
                     s.outFile:flush()
                     
                     event = g.getevent()
                     if (event:find("^key") or event:find("^oclick"))  then
                        logFile:write("doCollectChange stoped by user action Rule "..h.rule.." seed "..h.seed.."\n")
                        stop = true
                        break
                     end
                  if stop then break end
                  end
               end
               if stop then break end
            end
            if stop then break end
         end
         s.outFile:close()
      else
         comProcs.showTextOV('Failed to open output file '..scriptFileData.RESULTS_NEW)
      end
      local elapsed = os.clock()-startTime
      local elHrs = math.floor(elapsed/3600)
      local elMins = math.floor((elapsed-elHrs*3600)/60)
      local elSecs = (elapsed-elHrs*3600-elMins*60)
      g.show(string.format("Finished Run Length in %2d Hrs %2d Mins %2.2f Secs\n", elHrs,elMins,elSecs  ))
      logFile:write(string.format("Finished Run Length in %2d Hrs %2d Mins %2.2f Secs\n", elHrs,elMins,elSecs  ))
      logFile:flush()
      if logDiverted then
         reDivertLog()
      end
   else
      comProcs.showTextOV('No Script file Loaded')
   end   
end

return m
------------------------------------------------------------
